'use strict';
var directives = {};
directives.ngEnter = function() {
    return function(scope, elm, attrs) {
        elm.bind('keypress', function(e) {
            if (e.charCode === 13 || e.keyCode === 13) {
                scope.$apply(attrs.ngEnter);
            }
        });
    };
}

directives.nano = function() {
    return function(scope, elm, attrs) {
        elm.addClass('nano');
        $(elm).nanoScroller();
        $(elm).nanoScroller({
            flash: true,
            scroll: 'bottom',
            flashDelay: 100
        });
    };
}

directives.mask = function() {
    return {
        restrict: "EA",
        link: function(scope, elm, attrs) {
            elm.css('background', 'grey');
            elm.css('position', 'absolute');
            elm.css('top', 0);
            elm.css('left', 0);
            elm.css('z-index', 999);
            elm.css('opacity', 0.5);
            elm.css('width', elm.parent().width());
            elm.css('height', elm.parent().height() + 20);
        }
    }
}
//
//directives.numberField = function() {
//    return {
//        restrict: "A"
//        ,replace: true
//        ,require: '?ngModel'
//        ,scope: {
//            maxValue: "="
//            ,minValue: "="
//        }
//        ,link: function(scope, element, attrs, ngModelCtrl) {
//            var $scope = scope;
//
//            if(!ngModelCtrl) return; // do nothing if no ng-model
//
//            ngModelCtrl.$render = function() {
//                scope.value = ngModelCtrl.$viewValue || 0;
//            };
//
//            element.on('blur keyup change', function() {
//                scope.$apply(updateModel);
//            });
//
//
//            $scope.increaseVal = function() {
//                if(typeof $scope.maxValue != 'undefined')
//                {
//                    if(isNaN($scope.value) || $scope.value < $scope.maxValue)
//                    {
//                        $scope.value = Number(!isNaN($scope.value) ? $scope.value : 0) + 1;
//                    }
//                }
//                else
//                {
//                    $scope.value = Number(!isNaN($scope.value) ? $scope.value : 0) + 1;
//                }
//                updateModel();
//            }
//            $scope.decreaseVal = function() {
//                if($scope.value > 0)
//                {
//                    $scope.value = Number(!isNaN($scope.value) ? $scope.value : 0) - 1;
//                }
//                updateModel();
//            }
//
//            $scope.incDisabled = function(){
//                return (typeof $scope.maxValue != 'undefined' && $scope.value >= $scope.maxValue) ? true : false
//            }
//
//            $scope.decDisabled = function(){
//                return  ((typeof $scope.minValue != 'undefined' && $scope.value <= $scope.minValue) || (typeof $scope.minValue == 'undefined' && $scope.value <= 0)) ? true : false;
//            }
//
//            function updateModel(){
//                var value = scope.value;
//                value = (typeof value != 'undefined') ? Number(value) : 0;
//                value = (isNaN(value)) ? 0 : value;
//                ngModelCtrl.$setViewValue(value);
//            }
//        }
//        ,templateUrl: '/partials/directives/number_field.html'
//    }
//}

directives.priceField = function() {
    return {
        restrict: "A"
        ,replace: true
        ,require: '?ngModel'
        ,scope: {
            maxValue: "="
            ,minValue: "="
        }
        ,link: function(scope, element, attrs, ngModelCtrl) {
            var $scope = scope;

            if(!ngModelCtrl) return; // do nothing if no ng-model

            ngModelCtrl.$render = function() {
                scope.value = ngModelCtrl.$viewValue || 0;
            };

            element.on('blur keyup change', function() {
                normalizeValue();
                if($scope.incDisabled())
                {
                    $scope.value = $scope.maxValue;
                }
                if($scope.decDisabled())
                {
                    $scope.value = $scope.minValue;
                }
                $scope.$apply(updateModel);
            });


            $scope.increaseVal = function() {
                if(typeof $scope.maxValue != 'undefined')
                {
                    if(isNaN($scope.value) || $scope.value < $scope.maxValue)
                    {
                        $scope.value = parseFloat(!isNaN($scope.value) ? $scope.value : 0) + 1;
                    }
                }
                else
                {
                    $scope.value = parseFloat(!isNaN($scope.value) ? $scope.value : 0) + 1;
                }
                updateModel();
            }
            $scope.decreaseVal = function() {
                if($scope.value > 0)
                {
                    $scope.value = parseFloat(!isNaN($scope.value) ? $scope.value : 0) - 1;
                }
                updateModel();
            }

            $scope.incDisabled = function(){
                return (typeof $scope.maxValue != 'undefined' && $scope.value >= $scope.maxValue) ? true : false
            }

            $scope.decDisabled = function(){
                return  ((typeof $scope.minValue != 'undefined' && $scope.value <= $scope.minValue) || (typeof $scope.minValue == 'undefined' && $scope.value <= 0)) ? true : false;
            }

            function normalizeValue(){
                if(typeof scope.value != 'undefined')
                {
                    scope.value = (isNaN(scope.value)) ? scope.value.replace(/[^0-9\.\-]/g, '') : scope.value;
                    scope.value = (scope.value.length > 1) ? scope.value.replace(/^0+/g, '') : scope.value;
                    scope.value = (isNaN(scope.value)) ? 0 : scope.value;
                }
            }


            function updateModel(){
                var value = scope.value;
                value = (typeof value != 'undefined') ? parseFloat(value) : 0;
                value = (isNaN(value)) ? 0 : value;
                ngModelCtrl.$setViewValue(value);
            }
        }
        ,templateUrl: '/partials/directives/price_field.html'
    }
}

directives.tutorial = function() {
    return {
        restrict: "A"
        ,replace: true
        ,scope: {
            tutorial: "@"
        }
        ,controller: function($scope, $rootScope){
            $scope.openTutorial = function(){
                $rootScope.$broadcast('Tutorial:open', $scope.tutorial);
            }
        }
        ,template: '<a ng-click="openTutorial()" class="btn btn-default pull-right"><i class="fa fa-question-circle fa-lg"></i>Słownik pojęć</a>'
    }
}

directives.sliderElement = function(){
    return {
        require: 'ngModel'
        ,scope: {
            ngModel: '='
        }
        ,controller: function($scope){
            $scope.$watch('ngModel', function(newValue){
                $scope.element.value = newValue;
            })
        }
        ,link: function(scope, element, attr, ngModel){
            scope.element = element;
            element.slider({
                min: -20
                ,max: 20
                ,value: scope.ngModel
                ,slide: function(event, ui){
                    scope.$apply(function(){
                        ngModel.$setViewValue(ui.value);
                    });
                }
            });
        }
    }
}





// OLD DIRECTIVES TO ERASE
directives.pearsonElement = function() {
    return {
        restrict: "E",
        replace: true,
        scope: {
            memberNumber: "@",
            index: "@"
        },
        template: '<i class="fa fa-male fa-2x" style="padding-right: 4px" ng-class="{\'selected\': index < memberNumber}"></i>'
    };
}

directives.starElement = function() {
    return {
        restrict: "E",
        replace: true,
        scope: {
            memberNumber: "@",
            index: "@"
        },
        template: '<i class="fa fa-star fa-2x" style="padding-right: 4px" ng-class="{\'selected\': index*1 < memberNumber*1}"></i>'
    };
}

directives.checkboxGroup = function() {
    return {
        restrict: 'EA',
        controller: function($scope, $attrs) {
            var self = this;
            var ngModels = [];
            var minRequired;

            self.validate = function() {
                var checkedCount = 0;
                angular.forEach(ngModels, function(ngModel) {
                    if ( ngModel.$modelValue.checked ) {
                        checkedCount++;
                    }
                });
//                console.log('minRequired', minRequired);
//                console.log('checkedCount', checkedCount);
//                angular.forEach(ngModels, function(ngModel) {
//                    console.log(ngModel.$modelValue);
//                });

                var minRequiredValidity = checkedCount >= minRequired;
                angular.forEach(ngModels, function(ngModel) {
                    ngModel.$setValidity('checkboxGroup-minRequired', minRequiredValidity, self);
                });
            };

            self.register = function(ngModel) {
                ngModels.push(ngModel);
            };

            self.deregister = function(ngModel) {
                var index = (this.ngModels == undefined) ? -1 :this.ngModels.indexOf(ngModel);
                if ( index != -1 ) {
                   this.ngModels.splice(index, 1);
                }
            };

            $scope.$watch($attrs.minRequired, function(value) {
                minRequired = parseInt(value, 10);
                self.validate();
            });

        }
    };
};

directives.checkElement = function() {
    return {
        restrict: 'EA',
        require: ['?^checkboxGroup','?ngModel'],
        link: function(scope, element, attrs, controllers) {
            var checkboxGroup = controllers[0];
            var ngModel = controllers[1];
//            if ( attrs.type=='checkbox' && checkboxGroup && ngModel ) {
            if ( checkboxGroup && ngModel ) {
                checkboxGroup.register(ngModel);
                scope.$watch(function() { return ngModel.$modelValue.checked; }, checkboxGroup.validate );
                // In case we are adding and removing checkboxes dynamically we need to tidy up after outselves.
                scope.$on('$destroy', function() { checkboxGroup.deregister(ngModel); });
            }
        }
    };
};

directives.customValidator = function($parse) {
    return {
        require: "ngModel",
        //scope: false,
        link: function postLink(scope, elm, attrs, ctrl) {
            var validationFn = $parse(attrs.customValidator);
            var validator = function(value) {
                if(validationFn(scope, {val: value})) {
                    ctrl.$setValidity('custom-validator', true);
                    return value;
                }

                ctrl.$setValidity('custom-validator', false);
                return undefined;
            }
            ctrl.$parsers.unshift(validator);
            ctrl.$formatters.unshift(validator);
        }
    }
};

directives.tokensGroup = function() {
    return {
        restrict: 'EA',
        controller: function($scope, $attrs) {
            var self = this;
            var ngModels = [];
            var minRequired;

            self.validate = function() {
                var checkedCount = 0;
                angular.forEach(ngModels, function(ngModel) {
                    if ( ngModel.$modelValue.tokenValid ) {
                        checkedCount++;
                    }
                });
                var minRequiredValidity = checkedCount >= minRequired;
                angular.forEach(ngModels, function(ngModel) {
                    ngModel.$setValidity('tokensGroup-minRequired', minRequiredValidity, self);
                });
            };

            self.register = function(ngModel) {
                ngModels.push(ngModel);
            };

            self.deregister = function(ngModel) {
                var index = (this.ngModels == undefined) ? -1 :this.ngModels.indexOf(ngModel);
                if ( index != -1 ) {
                    this.ngModels.splice(index, 1);
                }
            };

            $scope.$watch($attrs.minRequired, function(value) {
                minRequired = parseInt(value, 10);
                self.validate();
            });

        }
    };
};

directives.tokenElement = function() {
    return {
        restrict: 'EA',
        require: ['?^tokensGroup','?ngModel'],
        link: function(scope, element, attrs, controllers) {
            var tokensGroup = controllers[0];
            var ngModel = controllers[1];
            if ( tokensGroup && ngModel ) {
                tokensGroup.register(ngModel);
                scope.$watch(function() { return ngModel.$modelValue.tokenValid; }, tokensGroup.validate );
                // In case we are adding and removing checkboxes dynamically we need to tidy up after outselves.
                scope.$on('$destroy', function() { tokensGroup.deregister(ngModel); });
            }
        }
    };
};
